﻿//*******************************************************************************
//This program connects to the instrument and sends and receives commands.
//Enter the command and click the [Transmit and Receive] button to send it.
//If the command has a response (command contains "?"), the response is displayed in the textbox.
//
//Add NationalInstruments.Common and NationalInstruments.NI4882 references to the project.
//These libraries are provided by National Instruments.
//
//System requirements (software)
//   Microsoft Visual Studio Professional 2017
//   Microsoft.NET Framework 4.7
//*******************************************************************************

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Sample
{
    public partial class Form1 : Form
    {
        private GPIB_NI comm;

        // Process for form load
        public Form1()
        {
            InitializeComponent();
            // Process for Enable/Disable on the buttons
            Button1.Enabled = true;
            Button2.Enabled = false;
            Button3.Enabled = false;
            TextBox1.Enabled = true;
            TextBox2.Enabled = true;
            TextBox3.Enabled = false;
            TextBox4.Enabled = false;
            TextBox5.ReadOnly = true;
        }

        // Events when "Connect" button is clicked
        private void Button1_Click(object sender, EventArgs e)
        {
            // Create a LAN object
            comm = new GPIB_NI();

            // Connect
            if (comm.OpenInterface(TextBox1.Text, TextBox2.Text) == false)
            {
                return;
            }

            // Process for Enable/Disable on the buttons
            Button1.Enabled = false;
            Button2.Enabled = true;
            Button3.Enabled = true;
            TextBox1.Enabled = false;
            TextBox2.Enabled = false;
            TextBox3.Enabled = true;
            TextBox4.Enabled = true;
        }

        // Events when "Disconnect" button is clicked
        private void Button2_Click(object sender, EventArgs e)
        {
            // Disconnect
            comm.CloseInterface();

            // Process for Enable/Disable on the buttons
            Button1.Enabled = true;
            Button2.Enabled = false;
            Button3.Enabled = false;
            TextBox1.Enabled = true;
            TextBox2.Enabled = true;
            TextBox3.Enabled = false;
            TextBox4.Enabled = false;
        }

        // Events when "Transmit and Receive" button is clicked
        private void Button3_Click(object sender, EventArgs e)
        {
            Button3.Enabled = false;

            TextBox5.AppendText("<< " + TextBox3.Text + "\r\n");                        // Output logs of transmitting data
            comm.SendQueryMsg(TextBox3.Text, Convert.ToInt64(TextBox4.Text) * 1000);    // Transmit and receive commands
            if (TextBox3.Text.Contains("?") == true)                                    // If the command contains "?"
            {
                TextBox5.AppendText(">> " + comm.MsgBuf + "\r\n");                      //Output logs of receiving data
            }

            Button3.Enabled = true;
        }

        // Events when "Clear" button is clicked
        private void Button4_Click(object sender, EventArgs e)
        {
            // Clear the textbox
            TextBox5.Clear();
        }

    }
}
